/*
 * Decompiled with CFR 0.152.
 */
package Project.Game.rooms;

import Data_Structures.Structures.BitSet;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Room;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.levelEditor.room_editor;
import Game_Engine.levelEditor.room_level;
import Project.Editor.Components.Spr;
import Project.Editor.Components.puzzle_editor;
import Project.Editor.Components.room_puzzle_editor;
import Project.Game.Componenets.guiBox;
import Project.Game.Componenets.levelButton;
import Project.Game.Componenets.obj_staticImages;
import Project.Game.objects.obj_goal;
import Project.Game.objects.obj_groundSquare;
import Project.Game.objects.obj_piece;
import Project.Game.objects.obj_teleport_target_mover;
import Project.Game.objects.obj_teleport_target_teleport;
import Project.Game.objects.obj_teleporter;
import Project.Game.rooms.room_main;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import util.FileIO;
import util.Serializations;
import util.StringParser;
import util.deSerialB;

public class room_puzzle_level
extends room_level
implements deSerialB {
    obj_staticImages scenery;
    gui_button back;
    levelButton l_button = null;

    public room_puzzle_level(File file) {
        super(file);
    }

    public room_puzzle_level(File file, levelButton l_button) {
        super(file);
        this.l_button = l_button;
    }

    @Override
    public void update() {
        super.update();
        if (this.back.flag()) {
            if (this.l_button == null) {
                this.returnToEditor();
                return;
            }
            if (this.levelSolved()) {
                this.l_button.newScore(guiBox.getScore());
            }
            this.room_goto(this.l_button.getRoom());
        }
    }

    public boolean levelSolved() {
        return true;
    }

    @Override
    public int getGameW() {
        return 1280;
    }

    @Override
    public int getGameH() {
        return 800;
    }

    @Override
    public room_editor createEditorRoom() {
        return new room_puzzle_editor();
    }

    @Override
    public Room createMenuRoom() {
        return new room_main();
    }

    @Override
    public String getExtension() {
        return "Hoth";
    }

    @Override
    public void iObjectHandlers() {
        this.scenery = new obj_staticImages(this);
        this.obj_create((Obj)this.scenery);
        guiBox box = puzzle_editor.createHud(this);
        this.back = new gui_button(box.getX2() - 110.0, box.getY(), 50, 50);
        this.back.setText("Done");
        this.back.setTextSize(12);
        this.obj_create((Obj)this.back);
        this.back.setDepth(box.getDepth() - 1);
    }

    @Override
    public void serializeFrom(File file) {
        List<String> input = FileIO.readFile(file);
        Iterator<String> iter2 = input.iterator();
        iter2.next();
        iter2.next();
        iter2.next();
        while (iter2.hasNext()) {
            int y;
            int x;
            int y1;
            int x1;
            int y12;
            int x12;
            int index;
            String s = iter2.next();
            if (s.equals("obj_guiBox")) {
                guiBox.setGoal(new Integer(iter2.next()));
                guiBox.disableEditing();
                continue;
            }
            Dict<String> dict = Serializations.deserial_dict(iter2);
            if (s.startsWith("obj_piece")) {
                index = StringParser.getEndDigit(s);
                x12 = new Integer((String)dict.lookup("x"));
                y12 = new Integer((String)dict.lookup("y"));
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                BitSet dir = new BitSet((String)dict.lookup("dir"));
                obj_piece p = new obj_piece((double)x12, (double)y12, index, dir);
                p.setArg2(x2, y2);
                this.obj_create((Obj)p);
                continue;
            }
            if (s.equals("obj_ground_square")) {
                x1 = new Integer((String)dict.lookup("x"));
                y1 = new Integer((String)dict.lookup("y"));
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                int grid_w = Spr.ground_square.getWidth();
                int grid_h = Spr.ground_square.getHeight();
                BitSet bs = new BitSet((String)dict.lookup("dir"));
                x = x1;
                while (x <= x2) {
                    y = y1;
                    while (y <= y2) {
                        this.obj_create((Obj)new obj_groundSquare(x, y, bs));
                        y += grid_h;
                    }
                    x += grid_w;
                }
                continue;
            }
            if (s.startsWith("obj_wall")) {
                x1 = new Integer((String)dict.lookup("x"));
                y1 = new Integer((String)dict.lookup("y"));
                int index2 = StringParser.getEndDigit(s);
                if (index2 >= 4) {
                    this.scenery.addImage(Spr.wall[index2], x1, y1);
                    continue;
                }
                if (index2 % 2 == 0) {
                    int y2 = new Integer((String)dict.lookup("y2"));
                    BufferedImage spr = Spr.wall[index2];
                    int inc = spr.getHeight();
                    int y3 = y1;
                    while (y3 <= y2) {
                        this.scenery.addImage(Spr.wall[index2], x1, y3);
                        y3 += inc;
                    }
                    continue;
                }
                int x2 = new Integer((String)dict.lookup("x2"));
                BufferedImage spr = Spr.wall[index2];
                int inc = spr.getHeight();
                int x3 = x1;
                while (x3 <= x2) {
                    this.scenery.addImage(Spr.wall[index2], x3, y1);
                    x3 += inc;
                }
                continue;
            }
            if (s.startsWith("obj_goal")) {
                index = StringParser.getEndDigit(s);
                x12 = new Integer((String)dict.lookup("x"));
                y12 = new Integer((String)dict.lookup("y"));
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                int grid_w = Spr.goal[index].getWidth();
                int grid_h = Spr.goal[index].getHeight();
                x = x12;
                while (x <= x2) {
                    y = y12;
                    while (y <= y2) {
                        this.obj_create((Obj)new obj_goal(x, y, index));
                        y += grid_h;
                    }
                    x += grid_w;
                }
                continue;
            }
            if (s.startsWith("obj_teleporter_target_mover")) {
                index = StringParser.getEndDigit(s);
                x12 = new Integer((String)dict.lookup("x"));
                y12 = new Integer((String)dict.lookup("y"));
                BitSet dir = new BitSet((String)dict.lookup("dir"));
                this.obj_create((Obj)new obj_teleport_target_mover((double)x12, (double)y12, index, dir));
                continue;
            }
            if (s.startsWith("obj_teleporter")) {
                index = StringParser.getEndDigit(s);
                x12 = new Integer((String)dict.lookup("x"));
                y12 = new Integer((String)dict.lookup("y"));
                this.obj_create((Obj)new obj_teleporter(x12, y12, index));
                continue;
            }
            if (!s.startsWith("obj_teleport_target_teleporter")) continue;
            index = StringParser.getEndDigit(s);
            x12 = new Integer((String)dict.lookup("x"));
            y12 = new Integer((String)dict.lookup("y"));
            BitSet dir = new BitSet((String)dict.lookup("dir"));
            this.obj_create((Obj)new obj_teleport_target_teleport((double)x12, (double)y12, index, dir));
        }
    }
}

